/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpDSATests.c,v 1.5 2000/08/31 22:14:15 hal Exp $
____________________________________________________________________________*/
#include "pgpPubTypes.h"
#include "pgpUtilities.h"
#include "pgpErrors.h"

#include "pgpUsuals.h"
#include "pgpMem.h"
#include "pgpContext.h"
#include "pgpPubKey.h"
#include "pgpRandomX9_17.h"
#include "pgpHashPriv.h"
#include "pgpDSAKey.h"

/* Buffers for known answer tests */

static PGPByte
sDSATestPubKey[] = {
	0x04, 0x00, 0xe1, 0x98, 0xd8, 0x9b, 0x41, 0xec,
	0xf7, 0xb4, 0xd9, 0xf1, 0xe6, 0x49, 0x4e, 0x2b,
	0x1a, 0x41, 0x20, 0x56, 0x3e, 0x4b, 0xba, 0xe9,
	0x3f, 0xbb, 0xe6, 0xc1, 0x35, 0xbb, 0x6e, 0x8f,
	0x5d, 0xf8, 0x9d, 0x67, 0x5c, 0x25, 0x96, 0xbd,
	0x98, 0x83, 0x6b, 0xf8, 0x6a, 0x47, 0xd5, 0x03,
	0x51, 0x5a, 0xdd, 0x01, 0xce, 0x82, 0xe9, 0x9f,
	0x28, 0xc8, 0x0e, 0xa3, 0x83, 0x1f, 0x62, 0xb6,
	0x7e, 0xe7, 0xb9, 0x56, 0xd3, 0xa8, 0xae, 0xc4,
	0xe0, 0xc7, 0x03, 0x5f, 0xa9, 0x27, 0xc9, 0x40,
	0x61, 0x4e, 0x2b, 0x37, 0x42, 0x33, 0xa0, 0xaf,
	0x81, 0x86, 0xdd, 0xd0, 0x64, 0xbe, 0xa9, 0xad,
	0x67, 0x1f, 0x97, 0xa9, 0x57, 0x2d, 0x45, 0xd6,
	0x03, 0x7c, 0x1e, 0x08, 0x06, 0x49, 0x83, 0xc5,
	0x9a, 0x4f, 0x15, 0x9f, 0x01, 0xce, 0xb1, 0x6f,
	0x0f, 0x2a, 0x44, 0xf3, 0xae, 0x67, 0x08, 0xcc,
	0x58, 0xb5, 0x00, 0xa0, 0xff, 0xbe, 0x73, 0x69,
	0xbb, 0xf1, 0xf9, 0x15, 0xb3, 0x5f, 0x31, 0xf4,
	0xe0, 0xad, 0xd2, 0x9d, 0x06, 0xdc, 0x86, 0x73,
	0x03, 0xfe, 0x24, 0x28, 0x37, 0x3a, 0x05, 0x1f,
	0xc6, 0xcc, 0xd1, 0x4a, 0x33, 0x8e, 0xf8, 0xd0,
	0xcb, 0xa6, 0x97, 0xd2, 0x62, 0xaa, 0x3a, 0x46,
	0x8d, 0xed, 0xa4, 0xaf, 0x0c, 0xdc, 0xe4, 0x49,
	0x3e, 0xb6, 0x32, 0x62, 0x06, 0x29, 0xfb, 0x8f,
	0xac, 0x8d, 0xe6, 0xd2, 0x5c, 0xa4, 0xea, 0xec,
	0x2f, 0x89, 0xe6, 0xb3, 0x24, 0xc0, 0x94, 0xa5,
	0x75, 0x1c, 0x6e, 0x4c, 0x3a, 0xc3, 0x6d, 0xf9,
	0x98, 0xfb, 0x91, 0x73, 0x0c, 0xfa, 0xc3, 0x6b,
	0x33, 0xf8, 0xfb, 0xdb, 0x3b, 0x26, 0x95, 0xb5,
	0x0b, 0xc3, 0xe4, 0x44, 0x29, 0x5c, 0x17, 0xd7,
	0xca, 0x08, 0xc4, 0x47, 0x28, 0x91, 0x0c, 0x36,
	0x26, 0xc5, 0xa5, 0x64, 0x80, 0xc7, 0xa1, 0x2b,
	0x4b, 0xf5, 0x10, 0x85, 0x8e, 0x7a, 0x43, 0xc8,
	0x60, 0x7e, 0xfe, 0x12, 0x76, 0x11, 0xfa, 0x5e,
	0x2f, 0x83, 0xc6, 0x25, 0x36, 0x85, 0x94, 0x01,
	0x55, 0x83, 0x04, 0x00, 0xc5, 0x33, 0x22, 0x98,
	0xd6, 0x9f, 0x1d, 0xd8, 0x5b, 0x47, 0x39, 0xdb,
	0x64, 0x4a, 0x1a, 0x09, 0xa8, 0x5b, 0x27, 0xf6,
	0xdd, 0x84, 0x0d, 0xb9, 0xfb, 0xfc, 0x9b, 0xc0,
	0x4d, 0xc7, 0xc3, 0xea, 0x71, 0x3d, 0x03, 0x4a,
	0x1b, 0xf7, 0x13, 0x59, 0x52, 0x41, 0x2b, 0x02,
	0xce, 0x34, 0x61, 0x39, 0xc9, 0x4a, 0xfb, 0xa8,
	0xe1, 0x6e, 0x1e, 0xfc, 0x3e, 0x22, 0x9c, 0xc8,
	0x48, 0x6c, 0xd9, 0x08, 0x75, 0xb7, 0x7f, 0x30,
	0x1e, 0x40, 0xe2, 0xcd, 0x22, 0x73, 0xcf, 0x04,
	0x4c, 0x12, 0x43, 0x42, 0x62, 0x9a, 0xa1, 0x3e,
	0xf6, 0xcf, 0x76, 0xc1, 0x49, 0xb5, 0xf1, 0x56,
	0x9c, 0x99, 0xef, 0xe2, 0x76, 0x7f, 0x46, 0x0e,
	0xcf, 0xb9, 0x30, 0x74, 0xd0, 0x1b, 0x02, 0xb2,
	0x13, 0xf8, 0x4d, 0x92, 0x2c, 0x1f, 0x05, 0xe3,
	0xa4, 0x26, 0x53, 0x99, 0x2d, 0x99, 0x59, 0x23,
	0x29, 0x1d, 0xcc, 0xf7
};

static PGPByte
sDSATestSecKey[] = {
	0x04, 0x00, 0xe1, 0x98, 0xd8, 0x9b, 0x41, 0xec,
	0xf7, 0xb4, 0xd9, 0xf1, 0xe6, 0x49, 0x4e, 0x2b,
	0x1a, 0x41, 0x20, 0x56, 0x3e, 0x4b, 0xba, 0xe9,
	0x3f, 0xbb, 0xe6, 0xc1, 0x35, 0xbb, 0x6e, 0x8f,
	0x5d, 0xf8, 0x9d, 0x67, 0x5c, 0x25, 0x96, 0xbd,
	0x98, 0x83, 0x6b, 0xf8, 0x6a, 0x47, 0xd5, 0x03,
	0x51, 0x5a, 0xdd, 0x01, 0xce, 0x82, 0xe9, 0x9f,
	0x28, 0xc8, 0x0e, 0xa3, 0x83, 0x1f, 0x62, 0xb6,
	0x7e, 0xe7, 0xb9, 0x56, 0xd3, 0xa8, 0xae, 0xc4,
	0xe0, 0xc7, 0x03, 0x5f, 0xa9, 0x27, 0xc9, 0x40,
	0x61, 0x4e, 0x2b, 0x37, 0x42, 0x33, 0xa0, 0xaf,
	0x81, 0x86, 0xdd, 0xd0, 0x64, 0xbe, 0xa9, 0xad,
	0x67, 0x1f, 0x97, 0xa9, 0x57, 0x2d, 0x45, 0xd6,
	0x03, 0x7c, 0x1e, 0x08, 0x06, 0x49, 0x83, 0xc5,
	0x9a, 0x4f, 0x15, 0x9f, 0x01, 0xce, 0xb1, 0x6f,
	0x0f, 0x2a, 0x44, 0xf3, 0xae, 0x67, 0x08, 0xcc,
	0x58, 0xb5, 0x00, 0xa0, 0xff, 0xbe, 0x73, 0x69,
	0xbb, 0xf1, 0xf9, 0x15, 0xb3, 0x5f, 0x31, 0xf4,
	0xe0, 0xad, 0xd2, 0x9d, 0x06, 0xdc, 0x86, 0x73,
	0x03, 0xfe, 0x24, 0x28, 0x37, 0x3a, 0x05, 0x1f,
	0xc6, 0xcc, 0xd1, 0x4a, 0x33, 0x8e, 0xf8, 0xd0,
	0xcb, 0xa6, 0x97, 0xd2, 0x62, 0xaa, 0x3a, 0x46,
	0x8d, 0xed, 0xa4, 0xaf, 0x0c, 0xdc, 0xe4, 0x49,
	0x3e, 0xb6, 0x32, 0x62, 0x06, 0x29, 0xfb, 0x8f,
	0xac, 0x8d, 0xe6, 0xd2, 0x5c, 0xa4, 0xea, 0xec,
	0x2f, 0x89, 0xe6, 0xb3, 0x24, 0xc0, 0x94, 0xa5,
	0x75, 0x1c, 0x6e, 0x4c, 0x3a, 0xc3, 0x6d, 0xf9,
	0x98, 0xfb, 0x91, 0x73, 0x0c, 0xfa, 0xc3, 0x6b,
	0x33, 0xf8, 0xfb, 0xdb, 0x3b, 0x26, 0x95, 0xb5,
	0x0b, 0xc3, 0xe4, 0x44, 0x29, 0x5c, 0x17, 0xd7,
	0xca, 0x08, 0xc4, 0x47, 0x28, 0x91, 0x0c, 0x36,
	0x26, 0xc5, 0xa5, 0x64, 0x80, 0xc7, 0xa1, 0x2b,
	0x4b, 0xf5, 0x10, 0x85, 0x8e, 0x7a, 0x43, 0xc8,
	0x60, 0x7e, 0xfe, 0x12, 0x76, 0x11, 0xfa, 0x5e,
	0x2f, 0x83, 0xc6, 0x25, 0x36, 0x85, 0x94, 0x01,
	0x55, 0x83, 0x04, 0x00, 0xc5, 0x33, 0x22, 0x98,
	0xd6, 0x9f, 0x1d, 0xd8, 0x5b, 0x47, 0x39, 0xdb,
	0x64, 0x4a, 0x1a, 0x09, 0xa8, 0x5b, 0x27, 0xf6,
	0xdd, 0x84, 0x0d, 0xb9, 0xfb, 0xfc, 0x9b, 0xc0,
	0x4d, 0xc7, 0xc3, 0xea, 0x71, 0x3d, 0x03, 0x4a,
	0x1b, 0xf7, 0x13, 0x59, 0x52, 0x41, 0x2b, 0x02,
	0xce, 0x34, 0x61, 0x39, 0xc9, 0x4a, 0xfb, 0xa8,
	0xe1, 0x6e, 0x1e, 0xfc, 0x3e, 0x22, 0x9c, 0xc8,
	0x48, 0x6c, 0xd9, 0x08, 0x75, 0xb7, 0x7f, 0x30,
	0x1e, 0x40, 0xe2, 0xcd, 0x22, 0x73, 0xcf, 0x04,
	0x4c, 0x12, 0x43, 0x42, 0x62, 0x9a, 0xa1, 0x3e,
	0xf6, 0xcf, 0x76, 0xc1, 0x49, 0xb5, 0xf1, 0x56,
	0x9c, 0x99, 0xef, 0xe2, 0x76, 0x7f, 0x46, 0x0e,
	0xcf, 0xb9, 0x30, 0x74, 0xd0, 0x1b, 0x02, 0xb2,
	0x13, 0xf8, 0x4d, 0x92, 0x2c, 0x1f, 0x05, 0xe3,
	0xa4, 0x26, 0x53, 0x99, 0x2d, 0x99, 0x59, 0x23,
	0x29, 0x1d, 0xcc, 0xf7, 0xff, 0x03, 0x03, 0x02,
	0xfd, 0xc0, 0x48, 0x8f, 0x4e, 0x5f, 0x26, 0x0a,
	0x60, 0xfd, 0x91, 0x3c, 0xc6, 0xa6, 0x59, 0x18,
	0xb3, 0xf4, 0x84, 0x28, 0xb2, 0x77, 0x55, 0xb7,
	0x5e, 0xbc, 0xe2, 0xb5, 0xd0, 0x09, 0x06, 0xde,
	0x8a, 0x63, 0xe1, 0x8c, 0x96, 0xff, 0xc1, 0xfc,
	0xaf
};

static PGPByte
sSigData[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
	0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
	0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55
};

static char
sPass[] = "Unlocking passphrase";



/* FIPS140 state Run DSA test */
	PGPError
pgpTestDSA(void)
{
	PGPContextRef 		context = kInvalidPGPContextRef;
	PGPSecKey		   *seckey = NULL;
	PGPPubKey		   *pubkey = NULL;
	PGPHashContextRef	hcontext = NULL;
	PGPHashVTBL const  *shavtbl;
	PGPRandomContext	*rcontext = NULL;
	PGPByte				shahash[20];
	PGPByte				sigbuf[64];
	PGPInt32			rslt;
	size_t				siglen;
	PGPEnv			   *pgpenv;
	PGPError			err = kPGPError_LazyProgrammer;
	PGPCustomContextInfo	info;
	
	pgpClearMemory( &info, sizeof( info ) );
	
	info.sdkAPIVersion 	= kPGPsdkAPIVersion;
	info.memoryMgr		= PGPGetDefaultMemoryMgr();
	
	err = PGPNewContextCustom( &info, &context );
	if( IsPGPError( err ) )
		goto error;
		
	pgpenv = pgpContextGetEnvironment( context );

	/* Create a deterministic pseudo random number generator */
	rcontext = pgpPseudoRandomCreate( context );

	/* Create secret and public key pair */
	seckey = pgpSecKeyFromBuf( context, kPGPPublicKeyAlgorithm_DSA,
							   sDSATestSecKey, sizeof( sDSATestSecKey ),
							   FALSE, NULL, &err );
	if( IsPGPError( err ) )
		goto error;
	pubkey = pgpPubKeyFromBuf( context, kPGPPublicKeyAlgorithm_DSA,
							   sDSATestPubKey, sizeof( sDSATestPubKey ),
							   &err );
	if( IsPGPError( err ) )
		goto error;
	
	/* Unlock secret key */
	rslt = pgpSecKeyUnlock( seckey, sPass, sizeof(sPass)-1, FALSE );
	if( rslt != 1 )
	{
		err = kPGPError_SelfTestFailed;
		goto error;
	}

	/* Hash the data we are signing/verifying */
	err = PGPNewHashContext( context, kPGPHashAlgorithm_SHA, &hcontext );
	if( IsPGPError( err ) )
		goto error;
	shavtbl = pgpHashGetVTBL( hcontext );
	PGPContinueHash( hcontext, sSigData, sizeof(sSigData) );
	PGPFinalizeHash( hcontext, shahash );

	/* Create a signature deterministically, verify it against known answer */
	if (pgpSecKeyMaxsig( seckey, kPGPPublicKeyMessageFormat_PGP ) >
		(PGPInt32)sizeof(sigbuf) )
	{
		err = kPGPError_SelfTestFailed;
		goto error;
	}
	err = pgpSecKeySign( seckey, shavtbl, shahash, sigbuf, &siglen,
						  rcontext, kPGPPublicKeyMessageFormat_PGP );
	if( IsPGPError( err ) )
		goto error;
	

	/* Check signature verification algorithm */
	rslt = pgpPubKeyVerify( pubkey, sigbuf, siglen,
							shavtbl, shahash, kPGPPublicKeyMessageFormat_PGP );
	if( rslt != 1 )
	{
		err = kPGPError_SelfTestFailed;
		goto error;
	}

	/* Everything is OK here */
	/* FALLTHROUGH */

 error:

	if( IsntNull( hcontext ) )
		PGPFreeHashContext( hcontext );
	if( IsntNull( rcontext ) )
		pgpRandomDestroy( rcontext );
	if( IsntNull( seckey ) )
		pgpSecKeyDestroy( seckey );
	if( IsntNull( pubkey ) )
		pgpPubKeyDestroy( pubkey );
	if( PGPContextRefIsValid( context ) )
		PGPFreeContext( context );
		
	/*
	** For the purposes of a self-test, only kPGPError_SelfTestFailed is
	** ever returned as an error code.
	*/
	
	if( IsPGPError( err ) )
		err = kPGPError_SelfTestFailed;
		
	return( err );
}
